This (private) repository handles the material for the
website of the ACM CoNEXT conference.

The website relies on AngularJS but 
basic HTML/CSS knowledge is enough for the webmaster(s)
for handling the website.

Unfortunately some operation are still awkward
and/or not easy to understand at first.

This README serves as reference notes for the conference yearly webmaster.
Beside managing the yearly website, please contribute to the
notes and add tooling if/where needed to ease
work for future webmasters :)

## How do I publish the website?

The website content is published by pushing to an FTP.
The credentials change from year to year.

## Files structure

The entry point is `index.html` but (almost no) edits
are required on this file when managing the yearly website.



#### The `/partials` folder
Most of the edits will fall in the `/partials` folder.
As from the folder name, this folder collects the
pages composing the website. Those are a collection
of HTML files that you need to edit depending on needs.

Special pages:

* `/partials/home.html`: this is the home page of the website.
* `/partials/importantdates`: this is the vertical block
of the home page showing the deadlines.
* `/partials/nav.html`: this composes the navigation bar
at the top of the website.

#### The `/js` folder

The AngulaJS logic of the website is in the `/js/app.js`.
Unless you need to create new pages (see notes below) 
or act on the routing of the pages, this file requires no edits.

More relevant is instead `/js/variables.js` which allows
you to inject some properties (update the year, location, etc.) 
in the website without editing the HTML.

#### The `/css` folder

The only relevant file is `/css/app.css` and,
unless you need to hack some style, the only
thing you need to change is the image of the jumbotron
(see comment below)


## Guidelines for webmasters


1.  Use `__attic_partials__`:
Try to push to the FTP __only the required files__.
In other words, even if a page is not directly linked
(say) from the home page, it might still be accessed
by knowing the URL and/or cloning the website.

In the attempt to limit the above, the
`__attic_partials__` folder collects all
partials that are NOT meant to published (yet).

As the website growth, you should progressively integrate
pages from this folder into the `/partials`.

2. Use `/dev` and `/main` branches:
You should develop using the `/dev` branch
but update the FTP via `/main`.

This is to try limiting publishing something
that was still in development.

3. Create a `tag`: The `/dev` and `/main`
branches reflect the current yearly conference.

Once a conference is complete, please create
a tag that function as an archive of the just
finished conference.


## How to serve the website locally?

You cannot simply open the website locally because
you need a backend processing first.

Luckly python offers a webserver that makes things easy for you

```
python -m http.server 8000
```

For convenience you can use the `serve.sh` to spawn the server.


## How to change the home page banner

The reference HTML file is `/partials/home.html`.

However, the image rendered for the banner is associated via
CSS. Specifically, search in `css/app.css` for `.jumbotron` class
which sets the `background-image` property.

__todo: add details about the image size__

## How to add new pages to the website?

See `/js/app.js`

Add an entry like
```
.state("mentoring", { url: "/mentoring", views: { mainView: { templateUrl: "partials/reception.html?updated=191205" } } })
```

The first variable will be the function invoked when composing the nav bar; the second the url and the inner path is the location of the file (in the example there are extra parameters but clearly this depends from what the page is programmed to do, and most commonly it till be just a path the .html file)

Once this is done, you likely need to link in the /partial/nav.html. For instance, the example above maps to the following tag
```
<a href="#/mentoring" ui-sref="mentoring()" class="dropdown-toggle">Call for Applications</a>
```
Notice the `ui-sref` corresponds to the 1st parameter in the `.state()` function from above



